<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                <?php echo e(__('Brand')); ?> <span class="accent-text">Dashboard</span>
            </h2>
            <a href="<?php echo e(route('campaigns.create')); ?>"
                class="v2-gradient text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4v16m8-8H4" />
                </svg>
                Create Campaign</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6 space-y-12">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-indigo-600/10 rounded-full blur-3xl group-hover:bg-indigo-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-indigo-400 font-black tracking-[0.3em] mb-4">Active Campaigns
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter">
                        <?php echo e($stats['active_campaigns']); ?></div>
                </div>
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-[#D4AF37]/10 rounded-full blur-3xl group-hover:bg-[#D4AF37]/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-[#D4AF37] font-black tracking-[0.3em] mb-4">Real Human Growth
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter">
                        <?php echo e($stats['total_submissions']); ?></div>
                </div>
            </div>

            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                <div class="p-10 border-b border-white/5 flex justify-between items-center bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">Your Recent <span
                            class="accent-text">Campaigns</span></h3>
                    <a href="<?php echo e(route('campaigns.index')); ?>"
                        class="text-[10px] font-black text-gray-400 hover:text-white uppercase tracking-widest transition-colors">Manage
                        All &rarr;</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-black/20">
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Campaign Title</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Status</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Rate</th>
                                <th
                                    class="px-10 py-5 text-right text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="px-10 py-6">
                                        <p class="text-sm font-black text-white tracking-tight"><?php echo e($campaign->title); ?></p>
                                        <p class="text-[10px] font-bold text-gray-500 uppercase mt-1">Created
                                            <?php echo e($campaign->created_at->format('M d, Y')); ?></p>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest',
                                            'bg-green-500/10 text-green-400 border border-green-500/20' => $campaign->status == 'active',
                                            'bg-yellow-500/10 text-yellow-400 border border-yellow-500/20' => $campaign->status == 'pending',
                                            'bg-blue-500/10 text-blue-400 border border-blue-500/20' => $campaign->status == 'completed',
                                        ]); ?>">
                                            <?php echo e($campaign->status); ?>

                                        </span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-sm font-black text-white tabular-nums">₦<?php echo e(number_format($campaign->rate_per_member, 2)); ?></span>
                                        <span class="text-[10px] font-bold text-gray-500">/ join</span>
                                    </td>
                                    <td class="px-10 py-6 text-right">
                                        <a href="<?php echo e(route('campaigns.show', $campaign)); ?>"
                                            class="text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">Manage</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Users\HP\Desktop\AWON SCRIPT\market\resources\views/brand/dashboard.blade.php ENDPATH**/ ?>