<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\ProofSubmissionController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
})->name('welcome');

Route::view('/privacy-center', 'privacy')->name('privacy');
Route::view('/terms-of-service', 'terms')->name('terms');

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Brand Routes
    Route::middleware('role:brand')->group(function () {
        Route::resource('campaigns', \App\Http\Controllers\CampaignController::class)->except(['show']);
        Route::get('/wallet', [PaymentController::class, 'index'])->name('wallet.index');
        Route::post('/wallet/fund', [PaymentController::class, 'initiatePaystack'])->name('wallet.fund');
    });

    // Shared Campaign Route
    Route::get('/campaigns/{campaign}', [\App\Http\Controllers\CampaignController::class, 'show'])->name('campaigns.show');

    Route::get('/payment/callback', [PaymentController::class, 'handleCallback'])->name('payment.callback');

    // Promoter Routes
    Route::middleware('role:promoter')->group(function () {
        Route::get('/browse-campaigns', [\App\Http\Controllers\CampaignController::class, 'index'])->name('campaigns.browse');
        Route::get('/campaigns/{campaign}/join', [\App\Http\Controllers\CampaignController::class, 'join'])->name('campaigns.join');
        Route::post('/campaigns/{campaign}/submit-proof', [\App\Http\Controllers\ProofSubmissionController::class, 'store'])->name('proof.submit');
        Route::get('/my-submissions', [\App\Http\Controllers\ProofSubmissionController::class, 'index'])->name('submissions.my');

        // Wallet & Withdrawal
        Route::get('/wallet/withdraw', [\App\Http\Controllers\PaymentController::class, 'showWithdrawForm'])->name('wallet.withdraw');
        Route::post('/wallet/withdraw', [\App\Http\Controllers\PaymentController::class, 'processWithdrawal'])->name('wallet.withdraw.process');
        Route::post('/wallet/bank-details', [\App\Http\Controllers\PaymentController::class, 'updateBankDetails'])->name('wallet.bank.update');
    });
    // Admin Routes
    Route::middleware('role:admin')->prefix('admin')->name('admin.')->group(function () {
        Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        Route::get('/submissions', [AdminController::class, 'submissions'])->name('submissions.index');
        Route::post('/submissions/{submission}/approve', [AdminController::class, 'approveSubmission'])->name('submissions.approve');
        Route::post('/submissions/{submission}/reject', [AdminController::class, 'rejectSubmission'])->name('submissions.reject');

        Route::get('/campaigns', [AdminController::class, 'campaigns'])->name('campaigns.index');
        Route::post('/campaigns/{campaign}/approve', [AdminController::class, 'approveCampaign'])->name('campaigns.approve');
        Route::post('/campaigns/{campaign}/reject', [AdminController::class, 'rejectCampaign'])->name('campaigns.reject');
        Route::patch('/campaigns/{campaign}/update-link', [AdminController::class, 'updateCampaignLink'])->name('campaigns.update_link');
        Route::get('/campaigns/{campaign}/links', [AdminController::class, 'manageLinks'])->name('campaigns.links');
        Route::post('/campaigns/{campaign}/links', [AdminController::class, 'storeLinks'])->name('campaigns.links.store');
        Route::delete('/links/{link}', [AdminController::class, 'deleteLink'])->name('campaigns.links.destroy');

        Route::get('/users', [AdminController::class, 'users'])->name('users.index');
        Route::post('/users/{user}/fund', [AdminController::class, 'fundWallet'])->name('users.fund');
    });
});

require __DIR__ . '/auth.php';
