<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">

            <!-- Alerts Section -->
            <div class="mb-10 space-y-6">
                @if(!auth()->user()->bankDetails)
                    <div
                        class="glass-card p-10 rounded-[3rem] border border-[#D4AF37]/20 flex flex-col md:flex-row items-center justify-between gap-8 animate-in fade-in slide-in-from-top duration-700 relative overflow-hidden group">
                        <div
                            class="absolute -right-10 -top-10 w-40 h-40 bg-[#D4AF37]/5 rounded-full blur-3xl group-hover:bg-[#D4AF37]/10 transition-all">
                        </div>

                        <div class="flex items-center gap-8 relative z-10 text-center md:text-left">
                            <div
                                class="w-20 h-20 bg-[#D4AF37]/10 rounded-3xl flex items-center justify-center text-[#D4AF37] shrink-0 border border-[#D4AF37]/20 shadow-xl">
                                <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                        d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-2xl font-black text-white tracking-tight italic">Bank Details Missing</h4>
                                <p class="text-[10px] font-black text-[#D4AF37] opacity-80 uppercase tracking-[0.3em] mt-2">
                                    Please add your bank details to withdraw funds</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if(session('success'))
                    <div
                        class="glass-card p-8 rounded-[2.5rem] border border-green-500/20 flex items-center gap-6 animate-in fade-in slide-in-from-top duration-500">
                        <div
                            class="w-14 h-14 bg-green-500/10 rounded-2xl flex items-center justify-center text-green-400 shrink-0 border border-green-500/20">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                        <p class="text-white font-black text-sm uppercase tracking-widest italic">{{ session('success') }}
                        </p>
                    </div>
                @endif

                @if(session('error'))
                    <div
                        class="glass-card p-8 rounded-[2.5rem] border border-red-500/20 flex items-center gap-6 animate-in fade-in slide-in-from-top duration-500">
                        <div
                            class="w-14 h-14 bg-red-500/10 rounded-2xl flex items-center justify-center text-red-400 shrink-0 border border-red-500/20">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </div>
                        <p class="text-white font-black text-sm uppercase tracking-widest italic">{{ session('error') }}</p>
                    </div>
                @endif

                @if($errors->any())
                    <div class="glass-card p-10 rounded-[3rem] border border-red-500/10">
                        <div class="flex items-center gap-6 mb-6">
                            <div
                                class="w-12 h-12 bg-red-500/10 rounded-2xl flex items-center justify-center text-red-500 shrink-0 border border-red-500/20">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                </svg>
                            </div>
                            <p class="text-white font-black uppercase text-xs tracking-[0.3em] italic">Error <span
                                    class="text-red-500">Detected</span></p>
                        </div>
                        <ul class="space-y-2 ml-16">
                            @foreach ($errors->all() as $error)
                                <li
                                    class="text-[10px] font-black text-red-400 uppercase tracking-widest flex items-center gap-3">
                                    <span class="w-1.5 h-1.5 bg-red-500 rounded-full"></span>
                                    {{ $error }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <!-- Withdrawal Section -->
                <div class="space-y-10">
                    <div class="glass-card p-12 rounded-[3.5rem] border border-white/5 relative overflow-hidden group">
                        <div
                            class="absolute -right-20 -top-20 w-60 h-60 bg-[#D4AF37]/5 rounded-full blur-3xl group-hover:bg-[#D4AF37]/10 transition-all duration-700">
                        </div>

                        <div class="relative z-10">
                            <span class="text-[10px] font-black uppercase tracking-[0.4em] text-[#D4AF37]">Available
                                Balance</span>
                            <div class="flex items-start mt-6">
                                <span class="text-2xl font-black text-gray-500 mt-2 mr-2">₦</span>
                                <span
                                    class="text-6xl font-black text-white tracking-tighter tabular-nums">{{ number_format($wallet->balance, 2) }}</span>
                            </div>
                            <div class="mt-8 pt-8 border-t border-white/5 flex items-center gap-3 opacity-60">
                                <div class="w-2 h-2 bg-indigo-500 rounded-full animate-pulse"></div>
                                <p class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em]">Min
                                    Withdrawal: ₦1,000.00</p>
                            </div>
                        </div>
                    </div>

                    <div class="glass-card p-12 rounded-[3.5rem] border border-white/5 relative overflow-hidden">
                        <h3 class="text-2xl font-black text-white mb-10 tracking-tight italic">Withdraw <span
                                class="accent-text">Funds</span></h3>

                        <form action="{{ route('wallet.withdraw.process') }}" method="POST" class="space-y-10">
                            @csrf
                            <div class="space-y-4">
                                <label
                                    class="block text-[10px] font-black text-[#D4AF37] uppercase tracking-[0.4em] ml-4">Requested
                                    Amount</label>
                                <div class="relative">
                                    <span
                                        class="absolute left-8 top-1/2 -translate-y-1/2 font-black text-gray-600 text-2xl italic">₦</span>
                                    <input type="number" name="amount" placeholder="0.00" min="1000" step="0.01"
                                        class="w-full bg-white/5 border border-white/10 rounded-[2.5rem] py-7 pl-16 pr-8 text-3xl font-black text-white focus:border-[#D4AF37] focus:ring-0 transition-all outline-none tabular-nums placeholder-gray-800"
                                        required>
                                </div>
                            </div>

                            <button type="submit"
                                class="w-full v2-gradient py-7 rounded-[2.5rem] text-white font-black text-xs uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-[1.02] active:scale-95 transition-all duration-300 group">
                                Withdraw <span
                                    class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Bank Settings Section -->
                <div class="space-y-10">
                    <div class="glass-card p-12 rounded-[3.5rem] border border-white/5">
                        <h3 class="text-2xl font-black text-white mb-2 tracking-tight italic">Bank <span
                                class="accent-text">Details</span></h3>
                        <p class="text-gray-500 text-xs font-black uppercase tracking-widest mb-10 opacity-60">Your
                            withdrawal account</p>

                        <form action="{{ route('wallet.bank.update') }}" method="POST" class="space-y-8">
                            @csrf
                            <div class="space-y-6">
                                <div class="space-y-3">
                                    <label
                                        class="block text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-4">Bank
                                        Name</label>
                                    <input type="text" name="bank_name" value="{{ $bankDetails?->bank_name }}"
                                        placeholder="e.g. GTBank Global"
                                        class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-sm font-black text-white focus:border-indigo-500 focus:ring-0 transition-all outline-none placeholder-gray-800"
                                        required>
                                </div>
                                <div class="space-y-3">
                                    <label
                                        class="block text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-4">Account
                                        Number</label>
                                    <input type="text" name="account_number" value="{{ $bankDetails?->account_number }}"
                                        placeholder="0123456789"
                                        class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-sm font-black text-white focus:border-indigo-500 focus:ring-0 transition-all outline-none placeholder-gray-800"
                                        required>
                                </div>
                                <div class="space-y-3">
                                    <label
                                        class="block text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-4">Beneficiary
                                        Name</label>
                                    <input type="text" name="account_name" value="{{ $bankDetails?->account_name }}"
                                        placeholder="Full Legal Name"
                                        class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-sm font-black text-white focus:border-indigo-500 focus:ring-0 transition-all outline-none placeholder-gray-800"
                                        required>
                                </div>
                            </div>

                            <button type="submit"
                                class="w-full bg-white/5 border border-white/10 text-white rounded-[1.5rem] py-5 font-black text-[10px] uppercase tracking-[0.3em] hover:bg-white/10 hover:border-white/20 transition-all duration-300 mt-4">
                                Save Bank Details
                            </button>
                        </form>
                    </div>

                    <!-- Note -->
                    <div
                        class="glass-card p-10 rounded-[3rem] border border-indigo-500/10 relative overflow-hidden group">
                        <div
                            class="absolute -left-10 -bottom-10 w-40 h-40 bg-indigo-600/5 rounded-full blur-3xl group-hover:bg-indigo-600/10 transition-all">
                        </div>
                        <div class="flex gap-6 relative z-10">
                            <div
                                class="shrink-0 w-12 h-12 bg-indigo-500/10 rounded-2xl flex items-center justify-center text-indigo-400 border border-indigo-500/20">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                        d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <p
                                class="text-[10px] font-black text-gray-500 leading-relaxed uppercase tracking-[0.2em] italic">
                                Note: Withdrawals are processed within 24-48 hours. Please ensure your bank details are
                                correct.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>