<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ __('Promoter') }} <span class="accent-text">Dashboard</span>
            </h2>
            <div class="flex gap-4">
                <a href="{{ route('campaigns.browse') }}"
                    class="bg-white/5 border border-white/10 text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:bg-white/10 transition-all duration-300">
                    Find Campaigns</a>
                <a href="{{ route('submissions.my') }}"
                    class="v2-gradient text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                    </svg>
                    My Submissions</a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6 space-y-12">
            @if(!auth()->user()->bankDetails)
                <div
                    class="glass-card border-l-4 border-[#D4AF37] p-8 rounded-3xl flex items-center justify-between animate-in slide-in-from-top duration-700">
                    <div class="flex items-center gap-6">
                        <div
                            class="w-14 h-14 bg-[#D4AF37]/10 rounded-2xl flex items-center justify-center text-[#D4AF37] shrink-0 border border-[#D4AF37]/20">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                            </svg>
                        </div>
                        <div>
                            <h4 class="text-sm font-black text-[#D4AF37] uppercase tracking-[0.2em]">Bank Details Missing
                            </h4>
                            <p class="text-xs font-bold text-gray-400 mt-1">Please set up your account details to enable
                                withdrawals.</p>
                        </div>
                    </div>
                    <a href="{{ route('wallet.withdraw') }}"
                        class="bg-[#D4AF37] text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:bg-[#B8962E] transition-all shadow-lg shadow-[#D4AF37]/20">Set
                        Up Now</a>
                </div>
            @endif

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group overflow-hidden relative">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-indigo-600/10 rounded-full blur-3xl group-hover:bg-indigo-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-[#D4AF37] font-black tracking-[0.3em] mb-4">Approved Balance
                    </div>
                    <div class="text-5xl font-black text-white tabular-nums tracking-tighter mb-8">
                        ₦{{ number_format($stats['balance'], 2) }}</div>
                    <a href="{{ route('wallet.withdraw') }}"
                        class="inline-flex items-center gap-2 v2-gradient text-white px-6 py-2.5 rounded-full text-[10px] font-black uppercase tracking-widest transition hover:scale-105">
                        Withdraw
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                    </a>
                </div>

                <div
                    class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group border-t-4 border-yellow-500/30">
                    <div class="text-[10px] uppercase text-gray-400 font-black tracking-[0.3em] mb-4">Awaiting Review
                    </div>
                    <div class="text-5xl font-black text-white tabular-nums tracking-tighter mb-4">
                        {{ $stats['pending_submissions'] }}</div>
                    <div class="text-[10px] font-bold text-gray-500 uppercase tracking-widest">Growth pending
                        verification</div>
                </div>

                <div
                    class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group border-t-4 border-blue-500/30">
                    <div class="text-[10px] uppercase text-blue-400 font-black tracking-[0.3em] mb-4">Reputation Score
                    </div>
                    <div class="text-5xl font-black text-white tabular-nums tracking-tighter mb-4">
                        {{ auth()->user()->trust_score }}</div>
                    <div class="text-[10px] font-bold text-gray-500 uppercase tracking-widest">Target: 200 for VIP</div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                <div class="p-10 border-b border-white/5 flex justify-between items-center bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">Recent <span
                            class="accent-text">Activity</span></h3>
                    <a href="{{ route('submissions.my') }}"
                        class="text-[10px] font-black text-gray-400 hover:text-white uppercase tracking-widest transition-colors">View
                        All &rarr;</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-black/20">
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Campaign</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Submitted</th>
                                <th
                                    class="px-10 py-5 text-right text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($recentSubmissions as $submission)
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="px-10 py-6">
                                        <p class="text-sm font-black text-white tracking-tight">
                                            {{ $submission->campaign->title }}</p>
                                        <p class="text-[10px] font-bold text-gray-500 uppercase mt-1">Ref:
                                            #{{ 1000 + $submission->id }}</p>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-xs font-bold text-gray-400">{{ $submission->created_at->diffForHumans() }}</span>
                                    </td>
                                    <td class="px-10 py-6 text-right">
                                        <span @class([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest',
                                            'bg-green-500/10 text-green-400 border border-green-500/20' => $submission->status == 'approved',
                                            'bg-yellow-500/10 text-yellow-400 border border-yellow-500/20' => $submission->status == 'pending',
                                            'bg-red-500/10 text-red-400 border border-red-500/20' => $submission->status == 'rejected',
                                        ])>
                                            {{ $submission->status }}
                                        </span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="px-10 py-24 text-center">
                                        <div class="text-gray-600 font-bold uppercase tracking-widest text-xs">No recent
                                            submissions found</div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>