<section>
    <header>
        <h2 class="text-2xl font-black text-white italic tracking-tight uppercase">
            {{ __('Profile Information') }}
        </h2>

        <p class="mt-2 text-[10px] font-black text-gray-500 uppercase tracking-widest italic leading-relaxed">
            {{ __("Update your account's profile information and email address.") }}
        </p>
    </header>

    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}" class="mt-10 space-y-8">
        @csrf
        @method('patch')

        <div class="space-y-3">
            <label for="name" class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Full Name</label>
            <input id="name" name="name" type="text"
                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                value="{{ old('name', $user->name) }}" required autofocus autocomplete="name" />
            <x-input-error class="mt-2 ml-4" :messages="$errors->get('name')" />
        </div>

        <div class="space-y-3">
            <label for="email"
                class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Email Address</label>
            <input id="email" name="email" type="email"
                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                value="{{ old('email', $user->email) }}" required autocomplete="username" />
            <x-input-error class="mt-2 ml-4" :messages="$errors->get('email')" />

            @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && !$user->hasVerifiedEmail())
                <div class="mt-4 p-6 bg-yellow-500/5 border border-yellow-500/10 rounded-2xl">
                    <p class="text-[10px] font-black text-yellow-500 uppercase tracking-widest italic">
                        {{ __('Status: Unverified') }}

                        <button form="send-verification"
                            class="block mt-2 underline text-yellow-400 hover:text-yellow-300 transition-colors">
                            {{ __('Click here to re-send the verification email.') }}
                        </button>
                    </p>

                    @if (session('status') === 'verification-link-sent')
                        <p class="mt-3 font-black text-[9px] text-green-500 uppercase tracking-widest italic">
                            {{ __('A new verification link has been sent to your email address.') }}
                        </p>
                    @endif
                </div>
            @endif
        </div>

        <div class="flex items-center gap-6 pt-4">
            <button type="submit"
                class="px-12 py-5 v2-gradient text-white rounded-full font-black text-[10px] uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-105 active:scale-95 transition-all duration-300">
                Save Changes
            </button>

            @if (session('status') === 'profile-updated')
                <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                    class="text-[10px] font-black text-green-500 uppercase tracking-widest italic">
                    {{ __('Profile Updated.') }}
                </p>
            @endif
        </div>
    </form>
</section>