<section>
    <header>
        <h2 class="text-2xl font-black text-white italic tracking-tight uppercase">
            {{ __('Update Password') }}
        </h2>

        <p class="mt-2 text-[10px] font-black text-gray-500 uppercase tracking-widest italic leading-relaxed">
            {{ __('Ensure your account is using a long, random password to stay secure.') }}
        </p>
    </header>

    <form method="post" action="{{ route('password.update') }}" class="mt-10 space-y-8">
        @csrf
        @method('put')

        <div class="space-y-3">
            <label for="update_password_current_password"
                class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Current Password</label>
            <input id="update_password_current_password" name="current_password" type="password"
                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                autocomplete="current-password" />
            <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2 ml-4" />
        </div>

        <div class="space-y-3">
            <label for="update_password_password"
                class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">New Encryption
                Password</label>
            <input id="update_password_password" name="password" type="password"
                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                autocomplete="new-password" />
            <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2 ml-4" />
        </div>

        <div class="space-y-3">
            <label for="update_password_password_confirmation"
                class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Confirm Password</label>
            <input id="update_password_password_confirmation" name="password_confirmation" type="password"
                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                autocomplete="new-password" />
            <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2 ml-4" />
        </div>

        <div class="flex items-center gap-6 pt-4">
            <button type="submit"
                class="px-12 py-5 v2-gradient text-white rounded-full font-black text-[10px] uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-105 active:scale-95 transition-all duration-300">
                Update Password
            </button>

            @if (session('status') === 'password-updated')
                <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                    class="text-[10px] font-black text-green-500 uppercase tracking-widest italic">
                    {{ __('Password Updated.') }}
                </p>
            @endif
        </div>
    </form>
</section>