<section class="space-y-8">
    <header>
        <h2 class="text-2xl font-black text-red-500 italic tracking-tight uppercase">
            {{ __('Delete Account') }}
        </h2>

        <p class="mt-2 text-[10px] font-black text-gray-500 uppercase tracking-widest italic leading-relaxed">
            {{ __('Permanently delete your account. This action is irreversible.') }}
        </p>
    </header>

    <button x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-user-deletion')"
        class="px-10 py-4 bg-red-600/10 border border-red-500/20 text-red-500 rounded-2xl font-black text-[10px] uppercase tracking-[0.3em] hover:bg-red-600 hover:text-white transition-all duration-300 italic">{{ __('Delete Account') }}</button>

    <x-modal name="confirm-user-deletion" :show="$errors->userDeletion->isNotEmpty()" focusable>
        <form method="post" action="{{ route('profile.destroy') }}"
            class="p-10 bg-[#020617] border border-red-500/20 rounded-[3rem]">
            @csrf
            @method('delete')

            <h2 class="text-2xl font-black text-white italic tracking-tight uppercase">
                {{ __('Are you sure?') }}
            </h2>

            <p class="mt-4 text-[10px] font-black text-gray-500 uppercase tracking-widest italic leading-relaxed">
                {{ __('Once deleted, all your data will be permanently removed. Please enter your password to confirm.') }}
            </p>

            <div class="mt-10 space-y-3">
                <label for="password"
                    class="text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Password</label>
                <input id="password" name="password" type="password"
                    class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] px-6 py-5 text-white font-black text-sm focus:border-red-500 focus:ring-4 focus:ring-red-500/10 outline-none transition-all duration-300 placeholder-gray-800 shadow-xl"
                    placeholder="{{ __('Password') }}" />

                <x-input-error :messages="$errors->userDeletion->get('password')" class="mt-2 ml-4" />
            </div>

            <div class="mt-10 flex items-center justify-end gap-6">
                <button type="button" x-on:click="$dispatch('close')"
                    class="text-[10px] font-black text-gray-500 uppercase tracking-widest hover:text-white transition-colors italic">
                    {{ __('Cancel') }}
                </button>

                <button type="submit"
                    class="px-10 py-4 bg-red-600 text-white rounded-2xl font-black text-[10px] uppercase tracking-[0.3em] shadow-2xl hover:bg-red-700 transition-all duration-300 italic">
                    {{ __('Delete Account') }}
                </button>
            </div>
        </form>
    </x-modal>
</section>