<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="mb-12 px-6">
                <h3 class="font-black text-4xl text-white tracking-tight italic">Account <span
                        class="accent-text">Settings</span></h3>
                <p class="text-[10px] font-black text-gray-500 uppercase tracking-[0.4em] mt-2 italic">Manage your
                    account preferences</p>
            </div>

            <div class="space-y-12">
                <div class="glass-card p-10 rounded-[3.5rem] border border-white/5 relative overflow-hidden group">
                    <div
                        class="absolute -right-20 -top-20 w-64 h-64 bg-indigo-600/5 rounded-full blur-[100px] group-hover:bg-indigo-600/10 transition-all duration-700">
                    </div>
                    <div class="max-w-xl relative z-10">
                        @include('profile.partials.update-profile-information-form')
                    </div>
                </div>

                <div class="glass-card p-10 rounded-[3.5rem] border border-white/5 relative overflow-hidden group">
                    <div
                        class="absolute -right-20 -top-20 w-64 h-64 bg-[#D4AF37]/5 rounded-full blur-[100px] group-hover:bg-[#D4AF37]/10 transition-all duration-700">
                    </div>
                    <div class="max-w-xl relative z-10">
                        @include('profile.partials.update-password-form')
                    </div>
                </div>

                <div class="glass-card p-10 rounded-[3.5rem] border border-red-500/10 relative overflow-hidden group">
                    <div
                        class="absolute -right-20 -top-20 w-64 h-64 bg-red-600/5 rounded-full blur-[100px] group-hover:bg-red-600/10 transition-all duration-700">
                    </div>
                    <div class="max-w-xl relative z-10">
                        @include('profile.partials.delete-user-form')
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>