<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;800;900&display=swap" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        body {
            font-family: 'Outfit', sans-serif;
            background-color: #020617;
            color: #f8fafc;
            min-height: 100vh;
        }

        .v2-gradient {
            background: linear-gradient(135deg, #1E3A8A 0%, #111827 100%);
        }

        .gold-glow {
            box-shadow: 0 0 50px -10px rgba(212, 175, 55, 0.1);
        }

        .glass-sidebar {
            background: rgba(255, 255, 255, 0.02);
            backdrop-filter: blur(20px);
            border-right: 1px solid rgba(255, 255, 255, 0.1);
        }

        .accent-text {
            background: linear-gradient(to right, #D4AF37, #fde68a);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>

<body class="antialiased">
    <div class="min-h-screen flex flex-col lg:flex-row">
        <!-- Sidebar (Educational Sideboard) - Desktop Only -->
        <div class="hidden lg:flex w-1/3 glass-sidebar flex-col justify-between p-16 sticky top-0 h-screen">
            <div
                class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] pointer-events-none">
            </div>

            <div class="relative z-10 space-y-12">
                <a href="/">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-10 h-10 bg-indigo-950 rounded-xl flex items-center justify-center border border-white/10 shadow-lg">
                            <svg class="w-6 h-6 text-[#D4AF37]" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5" />
                            </svg>
                        </div>
                        <span class="text-2xl font-black tracking-tight text-white">WhatsApp<span
                                class="text-[#D4AF37]">Grow</span></span>
                    </div>
                </a>

                @if(request()->routeIs('login'))
                    <div class="space-y-8 animate-in fade-in slide-in-from-left duration-700">
                        <h2 class="text-4xl font-black leading-tight italic">Welcome back to <br> <span
                                class="accent-text">the network.</span></h2>
                        <div class="space-y-6">
                            <div class="flex gap-4">
                                <div
                                    class="w-6 h-6 rounded-full bg-[#D4AF37]/20 border border-[#D4AF37]/40 flex items-center justify-center text-[#D4AF37] text-[10px] font-black">
                                    !</div>
                                <p class="text-gray-400 text-sm italic">"Growth starts with a single step. Log in to manage
                                    your campaigns or check your earnings."</p>
                            </div>
                            <ul class="space-y-4 text-xs font-bold text-gray-500 uppercase tracking-widest">
                                <li class="flex items-center gap-3">
                                    <span class="w-1.5 h-1.5 rounded-full bg-[#D4AF37]"></span>
                                    Manage Joined Groups
                                </li>
                                <li class="flex items-center gap-3">
                                    <span class="w-1.5 h-1.5 rounded-full bg-blue-500"></span>
                                    Withdraw Commissions
                                </li>
                            </ul>
                        </div>
                    </div>
                @else
                    <div class="space-y-10 animate-in fade-in slide-in-from-left duration-700">
                        <h2 class="text-4xl font-black leading-tight italic">Which path will <br> <span
                                class="accent-text">you choose?</span></h2>

                        <div class="space-y-8">
                            <div class="space-y-2">
                                <div class="text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37]">Path A</div>
                                <h4 class="text-xl font-bold text-white">The Brand</h4>
                                <p class="text-gray-500 text-sm leading-relaxed">Join to grow your WhatsApp groups with
                                    real, verified members from around the world.</p>
                            </div>
                            <div class="space-y-2">
                                <div class="text-[10px] font-black uppercase tracking-[0.3em] text-blue-500">Path B</div>
                                <h4 class="text-xl font-bold text-white">The Promoter</h4>
                                <p class="text-gray-400 text-sm leading-relaxed">Join to earn money by sharing group links
                                    with your communities and social network.</p>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="relative z-10 text-[10px] font-bold text-gray-600 uppercase tracking-widest">
                Trusted by 50,000+ users worldwide
            </div>
        </div>

        <!-- Form Area -->
        <div class="flex-grow flex flex-col bg-[#020617] relative min-h-screen">
            <!-- Mobile Header Logo -->
            <div class="lg:hidden flex justify-center pt-10 pb-6">
                <a href="/">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-10 h-10 bg-indigo-950 rounded-xl flex items-center justify-center border border-white/10 shadow-lg">
                            <svg class="w-6 h-6 text-[#D4AF37]" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5" />
                            </svg>
                        </div>
                        <span class="text-2xl font-black tracking-tight text-white">WhatsApp<span
                                class="text-[#D4AF37]">Grow</span></span>
                    </div>
                </a>
            </div>

            <div class="flex-grow flex items-center justify-center px-6 py-12 lg:py-24">
                <div class="max-w-md w-full">
                    {{ $slot }}
                </div>
            </div>

            <!-- Footer Small -->
            <div class="py-10 text-center text-[10px] font-black uppercase tracking-widest text-gray-700">
                © {{ date('Y') }} WhatsApp Grow &bull; <a href="#" class="hover:text-white transition">Privacy</a>
                &bull; <a href="#" class="hover:text-white transition">Terms</a>
            </div>
        </div>
    </div>
    <script>
        function togglePassword(id, btn) {
            const input = document.getElementById(id);
            const svg = btn.querySelector('svg');

            if (input.type === 'password') {
                input.type = 'text';
                svg.innerHTML =
                    '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l18 18" />';
            } else {
                input.type = 'password';
                svg.innerHTML =
                    '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /> <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />';
            }
        }
    </script>
</body>

</html>