<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ __('My') }} <span class="accent-text">Campaigns</span>
            </h2>
            <a href="{{ route('campaigns.create') }}"
                class="v2-gradient text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4v16m8-8H4" />
                </svg>
                Create New</a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6">
            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                @if (session('success'))
                    <div
                        class="mx-10 mt-10 bg-green-500/10 border border-green-500/20 rounded-2xl p-4 text-[10px] font-bold text-green-400 uppercase tracking-widest">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div
                        class="mx-10 mt-10 bg-red-500/10 border border-red-500/20 rounded-2xl p-4 text-[10px] font-bold text-red-400 uppercase tracking-widest">
                        {{ session('error') }}
                    </div>
                @endif
                <div class="p-10 border-b border-white/5 bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">Active <span
                            class="accent-text">Portfolio</span></h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-black/20">
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Title</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Status</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Rate</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Created</th>
                                <th
                                    class="px-10 py-5 text-right text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($campaigns as $campaign)
                                <tr class="hover:bg-white/5 transition-colors group">
                                    <td class="px-10 py-6">
                                        <p
                                            class="text-sm font-black text-white tracking-tight group-hover:text-[#D4AF37] transition-colors">
                                            {{ $campaign->title }}</p>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span @class([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest',
                                            'bg-green-500/10 text-green-400 border border-green-500/20' => $campaign->status == 'active',
                                            'bg-yellow-500/10 text-yellow-400 border border-yellow-500/20' => $campaign->status == 'pending',
                                            'bg-blue-500/10 text-blue-400 border border-blue-500/20' => $campaign->status == 'completed',
                                        ])>
                                            {{ $campaign->status }}
                                        </span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-sm font-black text-white tabular-nums">₦{{ number_format($campaign->rate_per_member, 2) }}</span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-[10px] font-bold text-gray-500 uppercase">{{ $campaign->created_at->format('M d, Y') }}</span>
                                    </td>
                                    <td class="px-10 py-6 text-right">
                                        <a href="{{ route('campaigns.show', $campaign) }}"
                                            class="text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">View
                                            Details</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-10 py-16 text-center">
                                        <div
                                            class="w-16 h-16 bg-white/5 rounded-full flex items-center justify-center mx-auto mb-4 border border-white/5">
                                            <span class="text-2xl">📁</span>
                                        </div>
                                        <p class="text-gray-500 font-medium italic">No campaigns found. Create your first
                                            one above!</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>