<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Verify <span
                class="accent-text">Email</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            Verify your email address</p>
    </div>

    <div class="mb-8 text-xs font-bold text-gray-500 leading-relaxed uppercase tracking-widest">
        {{ __('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.') }}
    </div>

    @if (session('status') == 'verification-link-sent')
        <div
            class="mb-8 p-4 bg-green-500/10 border border-green-500/20 rounded-2xl font-bold text-[10px] text-green-400 uppercase tracking-widest italic animate-pulse">
            {{ __('A new verification link has been sent to the email address you provided during registration.') }}
        </div>
    @endif

    <div class="space-y-6">
        <form method="POST" action="{{ route('verification.send') }}">
            @csrf

            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group text-center">
                {{ __('Resend Verification Email') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </form>

        <form method="POST" action="{{ route('logout') }}" class="text-center pt-4">
            @csrf

            <button type="submit"
                class="text-[9px] font-black uppercase tracking-[0.2em] text-gray-600 hover:text-white transition-colors underline underline-offset-8">
                {{ __('Log Out') }}
            </button>
        </form>
    </div>
</x-guest-layout>