<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Create <span
                class="accent-text">Account</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            Register for a new account</p>
    </div>

    <style>
        .role-card {
            transition: all 0.3s ease;
            border: 2px solid rgba(255, 255, 255, 0.05);
        }

        .role-radio:checked+.role-card {
            border-color: #D4AF37;
            background-color: rgba(212, 175, 55, 0.1);
            box-shadow: 0 0 30px rgba(212, 175, 55, 0.2);
        }

        .role-radio:checked+.role-card .role-icon {
            filter: grayscale(0);
            transform: scale(1.1);
        }

        .role-radio:checked+.role-card .role-title {
            color: #D4AF37;
        }

        .role-radio:checked+.role-card .role-check {
            opacity: 1;
        }

        /* Hide browser default password toggles */
        input::-ms-reveal,
        input::-ms-clear {
            display: none;
        }
    </style>

    <form method="POST" action="{{ route('register') }}" class="space-y-6">
        @csrf
        <!-- Honeypot -->
        <div style="display: none;">
            <input type="text" name="honey_pot" value="">
        </div>

        <!-- Role Selection -->
        <div class="space-y-3">
            <label class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Account
                Type</label>
            <div class="grid grid-cols-2 gap-4">
                <label class="cursor-pointer group relative block">
                    <input type="radio" name="role" value="promoter"
                        class="role-radio absolute inset-0 opacity-0 z-20 cursor-pointer w-full h-full" {{ old('role') == 'promoter' ? 'checked' : '' }} required>
                    <div
                        class="role-card relative p-6 rounded-3xl bg-white/5 hover:bg-white/10 text-center h-full flex flex-col items-center justify-center overflow-hidden z-10">
                        <!-- Checkmark -->
                        <div class="role-check absolute top-3 right-3 opacity-0 transition-opacity duration-300">
                            <div
                                class="w-6 h-6 bg-[#D4AF37] rounded-full flex items-center justify-center text-black text-xs font-bold">
                                ✓
                            </div>
                        </div>

                        <div
                            class="role-icon text-4xl mb-3 grayscale group-hover:grayscale-0 transition-all duration-300">
                            🚀</div>
                        <div class="role-title text-[10px] font-black uppercase tracking-widest text-white">Promoter
                        </div>
                        <div class="text-[9px] font-bold text-gray-400 mt-1">I want to earn</div>
                    </div>
                </label>
                <label class="cursor-pointer group relative block">
                    <input type="radio" name="role" value="brand"
                        class="role-radio absolute inset-0 opacity-0 z-20 cursor-pointer w-full h-full" {{ old('role') == 'brand' ? 'checked' : '' }} required>
                    <div
                        class="role-card relative p-6 rounded-3xl bg-white/5 hover:bg-white/10 text-center h-full flex flex-col items-center justify-center overflow-hidden z-10">
                        <!-- Checkmark -->
                        <div class="role-check absolute top-3 right-3 opacity-0 transition-opacity duration-300">
                            <div
                                class="w-6 h-6 bg-[#D4AF37] rounded-full flex items-center justify-center text-black text-xs font-bold">
                                ✓
                            </div>
                        </div>

                        <div
                            class="role-icon text-4xl mb-3 grayscale group-hover:grayscale-0 transition-all duration-300">
                            💼</div>
                        <div class="role-title text-[10px] font-black uppercase tracking-widest text-white">Brand</div>
                        <div class="text-[9px] font-bold text-gray-400 mt-1">I want growth</div>
                    </div>
                </label>
            </div>
            <x-input-error :messages="$errors->get('role')" class="text-center" />
        </div>

        <!-- Name -->
        <div class="space-y-3">
            <label for="name" class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Full
                Name</label>
            <input id="name"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                type="text" name="name" value="{{ old('name') }}" placeholder="e.g. Atlas Marketing" required autofocus
                autocomplete="name" />
            <x-input-error :messages="$errors->get('name')" class="mt-2" />
        </div>

        <!-- Email Address -->
        <div class="space-y-3">
            <label for="email" class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Email
                Address</label>
            <input id="email"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                type="email" name="email" value="{{ old('email') }}" placeholder="email@ecosystem.com" required
                autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="space-y-3">
            <label for="password"
                class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Password</label>
            <div class="relative group/pass">
                <input id="password"
                    class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 pl-8 pr-12 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                    type="password" name="password" placeholder="At least 8 bits" required
                    autocomplete="new-password" />
                <button type="button" onclick="togglePassword('password', this)" style="right: 1.5rem !important;"
                    class="absolute top-1/2 -translate-y-1/2 p-2 z-10 text-gray-500 hover:text-[#D4AF37] transition-colors focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="space-y-3">
            <label for="password_confirmation"
                class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Confirm
                Password</label>
            <div class="relative group/pass">
                <input id="password_confirmation"
                    class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 pl-8 pr-12 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                    type="password" name="password_confirmation" placeholder="Confirm secret" required
                    autocomplete="new-password" />
                <button type="button" onclick="togglePassword('password_confirmation', this)"
                    style="right: 1.5rem !important;"
                    class="absolute top-1/2 -translate-y-1/2 p-2 z-10 text-gray-500 hover:text-[#D4AF37] transition-colors focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="pt-6">
            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group text-center">
                {{ __('Register') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </div>

        <p
            class="text-center text-[9px] font-black text-gray-500 uppercase tracking-widest pt-10 border-t border-white/5">
            Already registered?
            <a href="{{ route('login') }}"
                class="text-[#D4AF37] hover:text-white transition-colors underline underline-offset-8 font-black ml-3">Log
                in</a>
        </p>
    </form>
</x-guest-layout>