<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Confirm <span
                class="accent-text">Password</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            This is a secure area of the application.</p>
    </div>

    <div class="mb-8 text-xs font-medium text-gray-400 leading-relaxed uppercase tracking-widest">
        {{ __('Please confirm your password before continuing.') }}
    </div>

    <form method="POST" action="{{ route('password.confirm') }}" class="space-y-8">
        @csrf

        <!-- Password -->
        <div class="space-y-3">
            <label for="password"
                class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Password</label>
            <input id="password"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                type="password" name="password" required autocomplete="current-password"
                placeholder="Confirm your secret" />
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <div class="pt-4">
            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group text-center">
                {{ __('Confirm') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </div>
    </form>
</x-guest-layout>