<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="flex items-center justify-between px-6 mb-12">
                <h3 class="font-black text-3xl text-white tracking-tight italic">User <span
                        class="accent-text">Management</span></h3>
                <p class="text-[10px] font-black text-gray-500 uppercase tracking-[0.4em] italic">Manage Users</p>
            </div>

            <div class="glass-card rounded-[3.5rem] border border-white/5 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-white/5 border-b border-white/5">
                            <tr>
                            <tr>
                                <th
                                    class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                    Name</th>
                                <th
                                    class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                    Email</th>
                                <th
                                    class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                    Role</th>
                                <th
                                    class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                    Wallet Balance</th>
                                <th
                                    class="px-10 py-6 text-right text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                    Actions</th>
                            </tr>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($users as $user)
                                <tr class="hover:bg-white/[0.02] transition-all duration-300 group">
                                    <td class="px-10 py-8">
                                        <div class="flex items-center gap-6">
                                            <div
                                                class="w-14 h-14 bg-white/5 rounded-2xl flex items-center justify-center text-gray-500 font-black border border-white/5 group-hover:bg-[#D4AF37] group-hover:text-white transition-all duration-500 shadow-lg italic">
                                                {{ substr($user->name, 0, 1) }}
                                            </div>
                                            <p class="font-black text-white tracking-tight text-lg italic uppercase">
                                                {{ $user->name }}
                                            </p>
                                        </div>
                                    </td>
                                    <td class="px-10 py-8">
                                        <p class="text-sm font-medium text-gray-400 italic">{{ $user->email }}</p>
                                    </td>
                                    <td class="px-10 py-8">
                                        <span @class([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest border italic',
                                            'bg-red-500/10 text-red-400 border-red-500/20' => $user->role === 'admin',
                                            'bg-indigo-500/10 text-indigo-400 border-indigo-500/20' => $user->role === 'brand',
                                            'bg-green-500/10 text-green-400 border-green-500/20' => $user->role === 'promoter',
                                        ])>
                                            {{ $user->role }}
                                        </span>
                                    </td>
                                    <td class="px-10 py-8 font-black text-white italic tabular-nums">
                                        <span class="text-gray-600 text-[10px] mr-1">₦</span>
                                        {{ number_format($user->wallet->balance ?? 0, 2) }}
                                    </td>
                                    <td class="px-10 py-8 text-right">
                                        @if($user->isBrand() || $user->isPromoter())
                                            <button
                                                onclick="openFundModal('{{ $user->id }}', '{{ $user->name }}', '{{ ucfirst($user->role) }}')"
                                                class="px-6 py-2.5 bg-white/5 border border-white/10 text-[#D4AF37] rounded-xl text-[9px] font-black uppercase tracking-widest hover:bg-[#D4AF37] hover:text-white transition-all duration-300 italic shadow-xl">
                                                Fund Wallet
                                            </button>
                                        @else
                                            <span
                                                class="text-[9px] font-black text-gray-700 uppercase tracking-widest italic">No
                                                Actions</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-10 py-32 text-center">
                                        <div
                                            class="w-24 h-24 bg-white/5 rounded-[2rem] flex items-center justify-center mx-auto mb-8 text-gray-600 border border-white/5">
                                            <svg class="w-12 h-12 opacity-20" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M12 4v16m8-8H4" />
                                            </svg>
                                        </div>
                                        <h5 class="text-white font-black text-2xl mb-3 tracking-tight italic">No Users Found
                                        </h5>
                                        <p
                                            class="text-gray-500 font-black text-[10px] uppercase tracking-[0.3em] max-w-xs mx-auto leading-relaxed italic">
                                            There are no users in the system.</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($users->hasPages())
                    <div class="px-10 py-10 bg-white/[0.01] border-t border-white/5">
                        {{ $users->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Fund Wallet Modal -->
    <div id="fund-admin-modal"
        class="fixed inset-0 bg-[#020617]/95 flex items-center justify-center hidden z-50 backdrop-blur-xl animate-in fade-in duration-300">
        <div
            class="glass-card rounded-[3.5rem] p-12 max-w-md w-full mx-4 shadow-2xl border border-white/10 relative overflow-hidden group">
            <div
                class="absolute -right-20 -top-20 w-64 h-64 bg-[#D4AF37]/5 rounded-full blur-[100px] group-hover:bg-[#D4AF37]/10 transition-all duration-700">
            </div>

            <div class="relative z-10">
                <h3 class="text-3xl font-black text-white mb-2 tracking-tight italic uppercase">Fund <span
                        class="accent-text">Wallet</span></h3>
                <div class="flex items-center gap-3 mb-10">
                    <span id="modal-user-role"
                        class="px-2 py-0.5 bg-[#D4AF37]/10 text-[#D4AF37] text-[8px] font-black uppercase rounded border border-[#D4AF37]/20 tracking-widest italic"></span>
                    <p id="modal-user-name"
                        class="text-gray-500 text-[10px] font-black uppercase tracking-widest italic"></p>
                </div>

                <form id="fund-form" action="" method="POST" class="space-y-8">
                    @csrf
                    <div class="space-y-3">
                        <label
                            class="block text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Amount
                            (NGN)</label>
                        <div class="relative">
                            <span class="absolute left-6 top-1/2 -translate-y-1/2 font-black text-gray-600">₦</span>
                            <input type="number" name="amount" step="0.01" min="0.01"
                                class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 pl-12 pr-6 text-sm font-black text-white focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800"
                                placeholder="0.00" required>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <label
                            class="block text-[10px] font-black text-gray-500 uppercase tracking-[0.3em] ml-2 italic">Description</label>
                        <input type="text" name="description"
                            class="w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-6 text-sm font-black text-white focus:border-[#D4AF37] focus:ring-4 focus:ring-[#D4AF37]/10 outline-none transition-all duration-300 placeholder-gray-800"
                            placeholder="Enter description...">
                    </div>

                    <div class="flex gap-6 pt-4">
                        <button type="button"
                            onclick="document.getElementById('fund-admin-modal').classList.add('hidden')"
                            class="flex-1 px-8 py-5 border border-white/10 text-gray-500 rounded-full font-black text-[10px] uppercase tracking-[0.3em] hover:text-white transition-all duration-300 italic">
                            Cancel
                        </button>
                        <button type="submit"
                            class="flex-1 px-8 py-5 v2-gradient text-white rounded-full font-black text-[10px] uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-105 transition-all duration-300">
                            Fund Wallet
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function openFundModal(userId, userName, userRole) {
            document.getElementById('modal-user-name').innerText = userName;
            document.getElementById('modal-user-role').innerText = userRole;
            document.getElementById('fund-form').action = `/admin/users/${userId}/fund`;
            document.getElementById('fund-admin-modal').classList.remove('hidden');
        }
    </script>
</x-app-layout>