<x-app-layout>
    <x-slot name="header">
        <div class="py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ __('Admin') }} <span class="accent-text">Dashboard</span>
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6 space-y-12">
            <!-- Stats Row -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-yellow-600/10 rounded-full blur-3xl group-hover:bg-yellow-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-yellow-400 font-black tracking-[0.3em] mb-4">Pending Reviews
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter mb-6">
                        {{ $stats['pending_submissions'] }}
                    </div>
                    <a href="{{ route('admin.submissions.index') }}"
                        class="inline-block text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">Review
                        Queue &rarr;</a>
                </div>

                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-indigo-600/10 rounded-full blur-3xl group-hover:bg-indigo-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-indigo-400 font-black tracking-[0.3em] mb-4">Total Campaigns
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter mb-6">
                        {{ $stats['total_campaigns'] }}
                    </div>
                    <a href="{{ route('admin.campaigns.index') }}"
                        class="inline-block text-[10px] font-black text-indigo-400 hover:text-white uppercase tracking-widest transition-colors border border-indigo-400/30 px-6 py-2 rounded-full hover:bg-indigo-500">Manage
                        Campaigns &rarr;</a>
                </div>

                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-blue-600/10 rounded-full blur-3xl group-hover:bg-blue-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-blue-400 font-black tracking-[0.3em] mb-4">Total Users</div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter mb-6">
                        {{ $stats['total_users'] }}
                    </div>
                    <a href="{{ route('admin.users.index') }}"
                        class="inline-block text-[10px] font-black text-blue-400 hover:text-white uppercase tracking-widest transition-colors border border-blue-400/30 px-6 py-2 rounded-full hover:bg-blue-500">Manage
                        Users &rarr;</a>
                </div>
            </div>

            <!-- Quick Access Section -->
            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                <div class="p-10 border-b border-white/5 bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">Quick <span
                            class="accent-text">Actions</span></h3>
                </div>
                <div class="p-10 grid md:grid-cols-3 gap-6">
                    <a href="{{ route('admin.submissions.index') }}"
                        class="glass-card p-8 rounded-3xl hover:bg-white/5 transition-all text-center group border border-white/5 hover:border-[#D4AF37]/30">
                        <span class="block text-4xl mb-4 group-hover:scale-110 transition-transform">📑</span>
                        <span class="text-[10px] font-black text-white uppercase tracking-[0.2em]">Submissions</span>
                    </a>
                    <a href="{{ route('admin.campaigns.index') }}"
                        class="glass-card p-8 rounded-3xl hover:bg-white/5 transition-all text-center group border border-white/5 hover:border-indigo-400/30">
                        <span class="block text-4xl mb-4 group-hover:scale-110 transition-transform">📢</span>
                        <span class="text-[10px] font-black text-white uppercase tracking-[0.2em]">Campaigns</span>
                    </a>
                    <a href="{{ route('admin.users.index') }}"
                        class="glass-card p-8 rounded-3xl hover:bg-white/5 transition-all text-center group border border-white/5 hover:border-blue-400/30">
                        <span class="block text-4xl mb-4 group-hover:scale-110 transition-transform">👥</span>
                        <span class="text-[10px] font-black text-white uppercase tracking-[0.2em]">Users</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>