<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\User;
use App\Models\Wallet;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For all users that don't have a wallet, create one.
        User::doesntHave('wallet')->get()->each(function ($user) {
            $user->wallet()->create([
                'balance' => 0,
                'pending_balance' => 0,
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // No need to reverse this as it just ensures data integrity
    }
};
