<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // SQLite doesn't support modifying columns directly easily, but assuming MySQL based on .env
        // If MySQL:
        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('earning', 'withdrawal', 'reversal', 'deposit', 'campaign_budget') NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('earning', 'withdrawal', 'reversal') NOT NULL");
    }
};
