<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProofSubmission extends Model
{
    /** @use HasFactory<\Database\Factories\ProofSubmissionFactory> */
    use HasFactory;

    protected $fillable = [
        'campaign_id',
        'promoter_id',
        'screenshot_path',
        'member_growth',
        'verification_code',
        'status',
        'admin_comment',
    ];

    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function promoter()
    {
        return $this->belongsTo(User::class, 'promoter_id');
    }
}
