<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    /** @use HasFactory<\Database\Factories\CampaignFactory> */
    use HasFactory;

    protected $fillable = [
        'brand_id',
        'title',
        'description',
        'whatsapp_link',
        'rate_per_member',
        'target_users',
        'total_cost',
        'status',
    ];

    public function brand()
    {
        return $this->belongsTo(User::class, 'brand_id');
    }

    public function submissions()
    {
        return $this->hasMany(ProofSubmission::class);
    }

    public function promoters()
    {
        return $this->belongsToMany(User::class, 'campaign_groups', 'campaign_id', 'promoter_id')
            ->withPivot('status')
            ->withTimestamps();
    }

    public function links()
    {
        return $this->hasMany(CampaignLink::class);
    }

    public function getRandomWhatsappLinkAttribute()
    {
        $link = $this->links()->where('is_active', true)->inRandomOrder()->first();
        return $link ? $link->group_link : $this->whatsapp_link;
    }
}
