<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class HoneypotMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->isMethod('POST') && $request->has('honey_pot')) {
            if (!empty($request->input('honey_pot'))) {
                // If the honedypot field is filled, it's a bot.
                // We can silently fail, or return a 422, or redirect back.
                // Aborting with 403 Forbidden is a safe bet.
                abort(403, 'Spam detected.');
            }
        }

        return $next($request);
    }
}
