<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Models\ProofSubmission;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $user = auth()->user();

        if ($user->isAdmin()) {
            $stats = [
                'pending_submissions' => ProofSubmission::where('status', 'pending')->count(),
                'total_campaigns' => Campaign::count(),
                'total_users' => \App\Models\User::count(),
            ];
            return view('admin.dashboard', compact('stats'));
        }

        if ($user->isBrand()) {
            $campaigns = $user->campaigns()->latest()->get();
            $stats = [
                'active_campaigns' => $user->campaigns()->where('status', 'active')->count(),
                'total_submissions' => ProofSubmission::whereIn('campaign_id', $user->campaigns()->pluck('id'))->count(),
            ];
            return view('brand.dashboard', compact('campaigns', 'stats'));
        }

        if ($user->isPromoter()) {
            $wallet = $user->wallet;
            $recentSubmissions = $user->submissions()->with('campaign')->latest()->take(5)->get();
            $stats = [
                'balance' => $wallet->balance,
                'pending_balance' => $user->submissions()->where('status', 'pending')->sum(DB::raw('member_growth * (select rate_per_member from campaigns where campaigns.id = proof_submissions.campaign_id)')),
                'joined_campaigns' => $user->campaigns()->count(),
            ];
            // Fix: Actually manual query for pending balance might be complex. 
            // Let's use simpler logic for now.
            $stats['pending_submissions'] = $user->submissions()->where('status', 'pending')->count();

            return view('promoter.dashboard', compact('stats', 'recentSubmissions'));
        }

        return view('dashboard');
    }
}
